/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingFurnaceUser;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAISkill;
import java.util.function.Predicate;
import net.minecraft.block.Blocks;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIUsesFurnace<J extends AbstractJob<?, J>, B extends AbstractBuildingFurnaceUser>
extends AbstractEntityAISkill<J, B> {
    protected static final double BASE_XP_GAIN = 2.0;
    private static final int RETRIEVE_SMELTABLE_IF_MORE_THAN = 10;
    protected static final int WAIT_AFTER_REQUEST = 50;

    protected AbstractEntityAIUsesFurnace(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 5), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorking, 60), new AITarget((IAIState)AIWorkerState.START_USING_FURNACE, this::fillUpFurnace, 5), new AIEventTarget(AIBlockingEventType.AI_BLOCKING, this::accelerateFurnaces, 20), new AITarget((IAIState)AIWorkerState.RETRIEVING_END_PRODUCT_FROM_FURNACE, this::retrieveSmeltableFromFurnace, 5), new AITarget((IAIState)AIWorkerState.RETRIEVING_USED_FUEL_FROM_FURNACE, this::retrieveUsedFuel, 5));
    }

    protected abstract void extractFromFurnace(FurnaceTileEntity var1);

    private void extractFuelFromFurnace(FurnaceTileEntity furnace) {
        InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler((IItemHandler)new InvWrapper((IInventory)furnace), 1, (IItemHandler)this.worker.getInventoryCitizen());
    }

    protected abstract boolean isSmeltable(ItemStack var1);

    protected boolean reachedMaxToKeep() {
        return false;
    }

    protected BlockPos getPositionOfOvenToRetrieveFrom() {
        for (BlockPos pos : ((AbstractBuildingFurnaceUser)this.getOwnBuilding()).getFurnaces()) {
            int countInInputSlot;
            TileEntity entity = this.world.func_175625_s(pos);
            if (!(entity instanceof FurnaceTileEntity)) continue;
            FurnaceTileEntity furnace = (FurnaceTileEntity)entity;
            int countInResultSlot = ItemStackUtils.isEmpty(furnace.func_70301_a(2)) != false ? 0 : furnace.func_70301_a(2).func_190916_E();
            int n = countInInputSlot = ItemStackUtils.isEmpty(furnace.func_70301_a(0)) != false ? 0 : furnace.func_70301_a(0).func_190916_E();
            if ((furnace.func_214006_r() || countInResultSlot <= 0) && countInResultSlot <= 10 && (countInResultSlot <= 0 || countInInputSlot != 0)) continue;
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.retrieving")});
            return pos;
        }
        return null;
    }

    protected BlockPos getPositionOfOvenToRetrieveFuelFrom() {
        for (BlockPos pos : ((AbstractBuildingFurnaceUser)this.getOwnBuilding()).getFurnaces()) {
            FurnaceTileEntity furnace;
            TileEntity entity = this.world.func_175625_s(pos);
            if (!(entity instanceof FurnaceTileEntity) || (furnace = (FurnaceTileEntity)entity).func_70301_a(1).func_190926_b() || ItemStackUtils.compareItemStackListIgnoreStackSize(((AbstractBuildingFurnaceUser)this.getOwnBuilding()).getAllowedFuel(), furnace.func_70301_a(1), false, false)) continue;
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.retrieving")});
            return pos;
        }
        return null;
    }

    public IAIState startWorking() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if (((AbstractBuildingFurnaceUser)this.getOwnBuilding()).getAllowedFuel().isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.furnaceuser.nofuel"), ChatPriority.BLOCKING));
            }
            return this.getState();
        }
        if (((AbstractBuildingFurnaceUser)this.getOwnBuilding()).getFurnaces().isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.bakery.nofurnace"), ChatPriority.BLOCKING));
            }
            return this.getState();
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.deciding")});
        IAIState nextState = this.checkForImportantJobs();
        if (nextState != AIWorkerState.START_WORKING) {
            return nextState;
        }
        BlockPos posOfUsedFuelOven = this.getPositionOfOvenToRetrieveFuelFrom();
        if (posOfUsedFuelOven != null) {
            this.walkTo = posOfUsedFuelOven;
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.retrieving")});
            return AIWorkerState.RETRIEVING_USED_FUEL_FROM_FURNACE;
        }
        BlockPos posOfOven = this.getPositionOfOvenToRetrieveFrom();
        if (posOfOven != null) {
            this.walkTo = posOfOven;
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.retrieving")});
            return AIWorkerState.RETRIEVING_END_PRODUCT_FROM_FURNACE;
        }
        int amountOfSmeltableInBuilding = InventoryUtils.getCountFromBuilding(this.getOwnBuilding(), this::isSmeltable);
        int amountOfSmeltableInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isSmeltable);
        int amountOfFuelInBuilding = InventoryUtils.getCountFromBuilding(this.getOwnBuilding(), ((AbstractBuildingFurnaceUser)this.getOwnBuilding())::isAllowedFuel);
        int amountOfFuelInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), ((AbstractBuildingFurnaceUser)this.getOwnBuilding())::isAllowedFuel);
        if (amountOfSmeltableInBuilding + amountOfSmeltableInInv <= 0 && !this.reachedMaxToKeep()) {
            this.requestSmeltable();
        }
        if (amountOfFuelInBuilding + amountOfFuelInInv <= 0 && !((AbstractBuildingFurnaceUser)this.getOwnBuilding()).hasWorkerOpenRequestsFiltered(this.worker.getCitizenData().getId(), req -> req.getShortDisplayString().func_150253_a().contains(new TranslationTextComponent("com.minecolonies.coremod.request.burnable")))) {
            this.worker.getCitizenData().createRequestAsync(new StackList(((AbstractBuildingFurnaceUser)this.getOwnBuilding()).getAllowedFuel(), "com.minecolonies.coremod.request.burnable", 64 * ((AbstractBuildingFurnaceUser)this.getOwnBuilding()).getFurnaces().size(), 1));
        }
        if (amountOfSmeltableInBuilding > 0 && amountOfSmeltableInInv == 0) {
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(this::isSmeltable, 64);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        if (amountOfFuelInBuilding > 0 && amountOfFuelInInv == 0) {
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(((AbstractBuildingFurnaceUser)this.getOwnBuilding())::isAllowedFuel, 64);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        return this.checkIfAbleToSmelt(amountOfFuelInBuilding + amountOfFuelInInv, amountOfSmeltableInBuilding + amountOfSmeltableInInv);
    }

    private IAIState accelerateFurnaces() {
        int accelerationTicks = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(((AbstractBuildingFurnaceUser)this.getOwnBuilding()).getPrimarySkill()) / 10 * 2;
        World world = ((AbstractBuildingFurnaceUser)this.getOwnBuilding()).getColony().getWorld();
        for (BlockPos pos : ((AbstractBuildingFurnaceUser)this.getOwnBuilding()).getFurnaces()) {
            TileEntity entity;
            if (!WorldUtil.isBlockLoaded((IWorld)world, pos) || !((entity = world.func_175625_s(pos)) instanceof FurnaceTileEntity)) continue;
            FurnaceTileEntity furnace = (FurnaceTileEntity)entity;
            for (int i = 0; i < accelerationTicks; ++i) {
                if (!furnace.func_214006_r()) continue;
                furnace.func_73660_a();
            }
        }
        return null;
    }

    public abstract void requestSmeltable();

    private IAIState checkIfAbleToSmelt(int amountOfFuel, int amountOfSmeltable) {
        for (BlockPos pos : ((AbstractBuildingFurnaceUser)this.getOwnBuilding()).getFurnaces()) {
            TileEntity entity = this.world.func_175625_s(pos);
            if (entity instanceof FurnaceTileEntity) {
                FurnaceTileEntity furnace = (FurnaceTileEntity)entity;
                if (!(amountOfFuel > 0 && ItemStackUtils.hasSmeltableInFurnaceAndNoFuel(furnace) || amountOfSmeltable > 0 && ItemStackUtils.hasFuelInFurnaceAndNoSmeltable(furnace)) && (amountOfFuel <= 0 || amountOfSmeltable <= 0 || !ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace))) continue;
                this.walkTo = pos;
                return AIWorkerState.START_USING_FURNACE;
            }
            if (this.world.func_180495_p(pos).func_177230_c() instanceof FurnaceBlock) continue;
            ((AbstractBuildingFurnaceUser)this.getOwnBuilding()).removeFromFurnaces(pos);
        }
        return this.checkForAdditionalJobs();
    }

    protected IAIState checkForAdditionalJobs() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.idling")});
        return AIWorkerState.START_WORKING;
    }

    protected IAIState checkForImportantJobs() {
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    private IAIState retrieveSmeltableFromFurnace() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.retrieving")});
        if (this.walkTo == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.walkTo)) {
            return this.getState();
        }
        TileEntity entity = this.world.func_175625_s(this.walkTo);
        if (!(entity instanceof FurnaceTileEntity) || ItemStackUtils.isEmpty(((FurnaceTileEntity)entity).func_70301_a(2)).booleanValue()) {
            this.walkTo = null;
            return AIWorkerState.START_WORKING;
        }
        this.walkTo = null;
        this.extractFromFurnace((FurnaceTileEntity)entity);
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.START_WORKING;
    }

    private IAIState retrieveUsedFuel() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.retrieving")});
        if (this.walkTo == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.walkTo)) {
            return this.getState();
        }
        TileEntity entity = this.world.func_175625_s(this.walkTo);
        if (!(entity instanceof FurnaceTileEntity) || ItemStackUtils.isEmpty(((FurnaceTileEntity)entity).func_70301_a(1)).booleanValue()) {
            this.walkTo = null;
            return AIWorkerState.START_WORKING;
        }
        this.walkTo = null;
        this.extractFuelFromFurnace((FurnaceTileEntity)entity);
        return AIWorkerState.START_WORKING;
    }

    private IAIState fillUpFurnace() {
        block8: {
            FurnaceTileEntity furnace;
            block9: {
                if (((AbstractBuildingFurnaceUser)this.getOwnBuilding()).getFurnaces().isEmpty()) {
                    if (this.worker.getCitizenData() != null) {
                        this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.bakery.nofurnace"), ChatPriority.BLOCKING));
                    }
                    return AIWorkerState.START_WORKING;
                }
                if (this.walkTo == null || this.world.func_180495_p(this.walkTo).func_177230_c() != Blocks.field_150460_al) {
                    this.walkTo = null;
                    return AIWorkerState.START_WORKING;
                }
                if (this.walkToBlock(this.walkTo)) {
                    return this.getState();
                }
                TileEntity entity = this.world.func_175625_s(this.walkTo);
                if (!(entity instanceof FurnaceTileEntity)) break block8;
                furnace = (FurnaceTileEntity)entity;
                if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isSmeltable) && (ItemStackUtils.hasFuelInFurnaceAndNoSmeltable(furnace) || ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace))) {
                    InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isSmeltable, 64, (IItemHandler)new InvWrapper((IInventory)furnace), 0);
                }
                if (!InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), ((AbstractBuildingFurnaceUser)this.getOwnBuilding())::isAllowedFuel)) break block8;
                if (ItemStackUtils.hasSmeltableInFurnaceAndNoFuel(furnace)) break block9;
                if (!ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace)) break block8;
            }
            InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), ((AbstractBuildingFurnaceUser)this.getOwnBuilding())::isAllowedFuel, 64, (IItemHandler)new InvWrapper((IInventory)furnace), 1);
        }
        this.walkTo = null;
        return AIWorkerState.START_WORKING;
    }

    protected abstract IRequestable getSmeltAbleClass();
}

